// SDD.cpp : implementation file
//

#include "stdafx.h"
#include "utf_edit.h"
#include "SDD.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// SDD dialog


SDD::SDD(CWnd* pParent /*=NULL*/)
	: CDialog(SDD::IDD, pParent)
{
	//{{AFX_DATA_INIT(SDD)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void SDD::SetType(int type)
{
	this->type = type;
}

void SDD::SetTreeItem(CTreeCtrl * tree, HTREEITEM item)
{
	this->tree = tree;
	this->item = item;
}


void SDD::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(SDD)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(SDD, CDialog)
	//{{AFX_MSG_MAP(SDD)
	ON_BN_CLICKED(IDUPDATE, OnUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// SDD message handlers

void SDD::OnUpdate() 
{
	int line;

	// get rid of existing data on this leaf
	void * data = (void *)tree->GetItemData(item);
	if (data) free (data);

	// update data
	CEdit * edit = (CEdit *) GetDlgItem(IDC_EDITDATA);
	int number_of_lines = edit->GetLineCount();

	switch (type)
	{
	case SDD_STRING:
		{
			char string[500];	memset(string, 0, 500);
			int len = edit->GetLine(0, string, 499) + 1;	// +1 is null terminator

			if ( (len % sizeof(DWORD)) != 0)		// dword alligned
				len += sizeof(DWORD) - (len % sizeof(DWORD));

			char * data = (char *) malloc (len+sizeof(int));	memset(data, 0, len+sizeof(int));
			strcpy (data + sizeof(int), string);
			*(int *)data = len;
			tree->SetItemData(item, (DWORD)data);
			break;
		}

	case SDD_INTARR:
		{
			int len = edit->GetLineCount() * sizeof(int);	// first guess re. the size of the data (some lines may be empty, so it may be smaller)
			int * buffer = (int *) malloc (len);
			int nEntries = 0;

			for (line = 0; line < edit->GetLineCount(); line ++)
			{
				char int_str[500];

				memset(int_str, 0, 500);
				edit->GetLine(line, int_str, 499);
				if (int_str[0] > 0)
					buffer[nEntries ++] = atoi(int_str);
			}

			char * data = (char *) malloc (nEntries * sizeof(int) + sizeof(int));	memset(data, 0, nEntries * sizeof(int) + sizeof(int));
			memcpy (data + sizeof(int), buffer, sizeof(int) * nEntries);
			*(int *)data = sizeof(int) * nEntries;
			tree->SetItemData(item, (DWORD)data);

			free (buffer);
			break;
		}

	case SDD_FLOATARR:
		{
			int len = edit->GetLineCount() * sizeof(float);	// first guess re. the size of the data (some lines may be empty, so it may be smaller)
			float * buffer = (float *) malloc (len);
			int nEntries = 0;

			for (line = 0; line < edit->GetLineCount(); line ++)
			{
				char flt_str[500];

				memset(flt_str, 0, 500);
				edit->GetLine(line, flt_str, 499);
				if (flt_str[0] > 0)
					buffer[nEntries ++] = atof(flt_str);
			}

			char * data = (char *) malloc (nEntries * sizeof(float) + sizeof(int));	memset(data, 0, nEntries * sizeof(float) + sizeof(int));
			memcpy (data + sizeof(int), buffer, sizeof(float) * nEntries);
			*(int *)data = sizeof(float) * nEntries;
			tree->SetItemData(item, (DWORD)data);

			free (buffer);
			break;
		}
	}


	// leave the dialog after updating
	OnCancel();
}

void SDD::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL SDD::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// set up edit box content based on type
	int i,c;
	char buffer[20000];	// more than enough to edit the small things
	memset(buffer, 0, 20000);

	// could be empty... if so, exit.
	if (tree->GetItemData(item) == 0) return TRUE;

	int total = (*(int *)tree->GetItemData(item)) / 4;	// both ints and floats are 4 bytes

	switch (type)
	{
	case SDD_STRING:
		strcpy (buffer, ((char *) tree->GetItemData(item)) + 4);
		break;
	case SDD_INTARR:
		for (c = 0,i = 0; i < total; i++)
		{
			c += sprintf(buffer + c, "%d", ((int *)tree->GetItemData(item))[i+1]);
			if (i < total - 1)
				c += sprintf(buffer + c, "\r\n");
		}
		break;
	case SDD_FLOATARR:
		for (c = 0,i = 0; i < total; i++)
		{
			c += sprintf(buffer + c, "%f", ((float *)tree->GetItemData(item))[i+1]);
			if (i < total - 1)
				c += sprintf(buffer + c, "\r\n");
		}
		break;
	}

	CEdit * edit = (CEdit *) GetDlgItem(IDC_EDITDATA);
	edit->FmtLines(true);
	edit->SetWindowText(buffer);

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
